/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import net.minecraft.class_1161;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.CreativeAABB;
import team.creative.creativecore.common.util.math.collision.CollidingPlane;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;

public class OBB
extends CreativeAABB {
    public IVecOrigin origin;
    public CollidingPlane.PlaneCache cache;
    public static final float EPSILON = 0.001f;

    public void buildCache() {
        this.cache = new CollidingPlane.PlaneCache(this);
    }

    public OBB(IVecOrigin origin, double x1, double y1, double z1, double x2, double y2, double z2) {
        super(x1, y1, z1, x2, y2, z2);
        this.origin = origin;
    }

    public OBB(IVecOrigin origin, class_238 bb) {
        super(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
        this.origin = origin;
    }

    public OBB setMinX(double value) {
        return new OBB(this.origin, value, this.field_1322, this.field_1321, this.field_1320, this.field_1325, this.field_1324);
    }

    public OBB setMinY(double value) {
        return new OBB(this.origin, this.field_1323, value, this.field_1321, this.field_1320, this.field_1325, this.field_1324);
    }

    public OBB setMinZ(double value) {
        return new OBB(this.origin, this.field_1323, this.field_1322, value, this.field_1320, this.field_1325, this.field_1324);
    }

    public OBB setMaxX(double value) {
        return new OBB(this.origin, this.field_1323, this.field_1322, this.field_1321, value, this.field_1325, this.field_1324);
    }

    public OBB setMaxY(double value) {
        return new OBB(this.origin, this.field_1323, this.field_1322, this.field_1321, this.field_1320, value, this.field_1324);
    }

    public OBB setMaxZ(double value) {
        return new OBB(this.origin, this.field_1323, this.field_1322, this.field_1321, this.field_1320, this.field_1325, value);
    }

    public OBB set(Facing facing, double value) {
        return switch (facing) {
            case Facing.EAST -> new OBB(this.origin, this.field_1323, this.field_1322, this.field_1321, value, this.field_1325, this.field_1324);
            case Facing.WEST -> new OBB(this.origin, value, this.field_1322, this.field_1321, this.field_1320, this.field_1325, this.field_1324);
            case Facing.UP -> new OBB(this.origin, this.field_1323, this.field_1322, this.field_1321, this.field_1320, value, this.field_1324);
            case Facing.DOWN -> new OBB(this.origin, this.field_1323, value, this.field_1321, this.field_1320, this.field_1325, this.field_1324);
            case Facing.SOUTH -> new OBB(this.origin, this.field_1323, this.field_1322, this.field_1321, this.field_1320, this.field_1325, value);
            case Facing.NORTH -> new OBB(this.origin, this.field_1323, this.field_1322, value, this.field_1320, this.field_1325, this.field_1324);
            default -> throw new UnsupportedOperationException();
        };
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof OBB)) {
            return false;
        }
        OBB axisalignedbb = (OBB)((Object)p_equals_1_);
        if (axisalignedbb.origin != this.origin) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_1323, this.field_1323) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_1322, this.field_1322) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_1321, this.field_1321) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_1320, this.field_1320) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_1325, this.field_1325) != 0) {
            return false;
        }
        return Double.compare(axisalignedbb.field_1324, this.field_1324) == 0;
    }

    public OBB contract(double x, double y, double z) {
        double d0 = this.field_1323;
        double d1 = this.field_1322;
        double d2 = this.field_1321;
        double d3 = this.field_1320;
        double d4 = this.field_1325;
        double d5 = this.field_1324;
        if (x < 0.0) {
            d0 -= x;
        } else if (x > 0.0) {
            d3 -= x;
        }
        if (y < 0.0) {
            d1 -= y;
        } else if (y > 0.0) {
            d4 -= y;
        }
        if (z < 0.0) {
            d2 -= z;
        } else if (z > 0.0) {
            d5 -= z;
        }
        return new OBB(this.origin, d0, d1, d2, d3, d4, d5);
    }

    public OBB expandTowards(double x, double y, double z) {
        double d0 = this.field_1323;
        double d1 = this.field_1322;
        double d2 = this.field_1321;
        double d3 = this.field_1320;
        double d4 = this.field_1325;
        double d5 = this.field_1324;
        if (x < 0.0) {
            d0 += x;
        } else if (x > 0.0) {
            d3 += x;
        }
        if (y < 0.0) {
            d1 += y;
        } else if (y > 0.0) {
            d4 += y;
        }
        if (z < 0.0) {
            d2 += z;
        } else if (z > 0.0) {
            d5 += z;
        }
        return new OBB(this.origin, d0, d1, d2, d3, d4, d5);
    }

    public OBB inflate(double x, double y, double z) {
        double d0 = this.field_1323 - x;
        double d1 = this.field_1322 - y;
        double d2 = this.field_1321 - z;
        double d3 = this.field_1320 + x;
        double d4 = this.field_1325 + y;
        double d5 = this.field_1324 + z;
        return new OBB(this.origin, d0, d1, d2, d3, d4, d5);
    }

    public OBB inflate(double value) {
        return this.inflate(value, value, value);
    }

    public OBB move(double x, double y, double z) {
        return new OBB(this.origin, this.field_1323 + x, this.field_1322 + y, this.field_1321 + z, this.field_1320 + x, this.field_1325 + y, this.field_1324 + z);
    }

    public OBB move(class_2338 pos) {
        return new OBB(this.origin, this.field_1323 + (double)pos.method_10263(), this.field_1322 + (double)pos.method_10264(), this.field_1321 + (double)pos.method_10260(), this.field_1320 + (double)pos.method_10263(), this.field_1325 + (double)pos.method_10264(), this.field_1324 + (double)pos.method_10260());
    }

    public static boolean smallerThanAndEquals(double a, double b) {
        return a < b || OBB.equals(a, b);
    }

    public static boolean greaterThanAndEquals(double a, double b) {
        return a > b || OBB.equals(a, b);
    }

    public static boolean equals(double a, double b) {
        return a == b || Math.abs(a - b) < (double)0.001f;
    }

    public double getMaxTranslated(Axis axis) {
        return this.getMax(axis) + this.origin.translationCombined(axis);
    }

    public double getMinTranslated(Axis axis) {
        return this.getMin(axis) + this.origin.translationCombined(axis);
    }

    public boolean method_994(class_238 other) {
        if (other instanceof OBB) {
            if (((OBB)other).origin == this.origin) {
                return this.field_1323 < other.field_1320 && this.field_1320 > other.field_1323 && this.field_1322 < other.field_1325 && this.field_1325 > other.field_1322 && this.field_1321 < other.field_1324 && this.field_1324 > other.field_1321;
            }
            OBB converted = ((OBB)other).origin.getOrientatedBox(this.origin.getAxisAlignedBox(this));
            return converted.field_1323 < other.field_1320 && converted.field_1320 > other.field_1323 && converted.field_1322 < other.field_1325 && converted.field_1325 > other.field_1322 && converted.field_1321 < other.field_1324 && converted.field_1324 > other.field_1321;
        }
        return this.method_1003(other.field_1323, other.field_1322, other.field_1321, other.field_1320, other.field_1325, other.field_1324);
    }

    public boolean method_1003(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        class_238 box = this.origin.getAxisAlignedBox(this);
        return box.field_1323 < maxX && box.field_1320 > minX && box.field_1322 < maxY && box.field_1325 > minY && box.field_1321 < maxZ && box.field_1324 > minZ;
    }

    public String toString() {
        return "box[" + this.field_1323 + ", " + this.field_1322 + ", " + this.field_1321 + " -> " + this.field_1320 + ", " + this.field_1325 + ", " + this.field_1324 + "]";
    }

    public class_1161 getCenter3d() {
        return new class_1161(this.field_1323 + (this.field_1320 - this.field_1323) * 0.5, this.field_1322 + (this.field_1325 - this.field_1322) * 0.5, this.field_1321 + (this.field_1324 - this.field_1321) * 0.5);
    }

    public double getPushOutScale(double minScale, OBB fakeBox, class_1161 pushVec) {
        boolean pushZ;
        double scale = Double.MAX_VALUE;
        boolean pushX = pushVec.field_5661 != 0.0;
        boolean pushY = pushVec.field_5660 != 0.0;
        boolean bl = pushZ = pushVec.field_5659 != 0.0;
        if (pushX) {
            scale = pushVec.field_5661 > 0.0 ? Math.min(scale, Math.abs((this.field_1320 - fakeBox.field_1323) / pushVec.field_5661)) : Math.min(scale, Math.abs((this.field_1323 - fakeBox.field_1320) / pushVec.field_5661));
        }
        if (pushY) {
            scale = pushVec.field_5660 > 0.0 ? Math.min(scale, Math.abs((this.field_1325 - fakeBox.field_1322) / pushVec.field_5660)) : Math.min(scale, Math.abs((this.field_1322 - fakeBox.field_1325) / pushVec.field_5660));
        }
        if (pushZ) {
            scale = pushVec.field_5659 > 0.0 ? Math.min(scale, Math.abs((this.field_1324 - fakeBox.field_1321) / pushVec.field_5659)) : Math.min(scale, Math.abs((this.field_1321 - fakeBox.field_1324) / pushVec.field_5659));
        }
        return Math.max(scale, minScale);
    }
}

